#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

long long count_pairs(const vector<int>& niz)
{
    long long br = 0;
    int n = niz.size();
    int i = 0;

    while (i < n)
    {
        int j = i;
        while (j < n && niz[i] == niz[j]) j++;

        long long k = j - i;        // broj istih elemenata
        br += k * (k - 1) / 2;      // broj parova

        i = j;
    }
    return br;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<int> x(n), y(n), d1(n), d2(n);

    for (int i = 0; i < n; i++)
    {
        cin >> x[i] >> y[i];
        d1[i] = x[i] + y[i];
        d2[i] = x[i] - y[i];
    }

    sort(x.begin(), x.end());
    sort(y.begin(), y.end());
    sort(d1.begin(), d1.end());
    sort(d2.begin(), d2.end());

    long long br = 0;
    br += count_pairs(x);
    br += count_pairs(y);
    br += 2 * count_pairs(d1);
    br += 2 * count_pairs(d2);

    cout << br << '\n';

    return 0;
}